set more off
pause off
clear
set level 90
macro drop _all
graph set window fontface "Times New Roman"
set seed 1073741823

cd ""
global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"
use "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",clear

gen rlcapx_gva = ln(((capxq *1000000) / (gva_pindex/100)) + 1) * 100
cap drop sic3
gen sic3 = int(sic/1000)

rename RRExtended Extracted_MPShockE  // Romer Extended shocks

replace Extracted_MPShockE = 0 if Extracted_MPShockE ==.

label var Extracted_MPShockE "MP Shock"
 
sort gvkeyn cyear cquarter
xtset gvkeyn qdate

capture macro drop nq
global nq = 1

capture drop shock_var*
capture drop group_var*

cap drop posit* negat*
gen positives = Extracted_MPShockE if gs1dp > 0 & gs1dp !=. 
gen negatives = Extracted_MPShockE if gs1dn < 0 & gs1dp !=.

replace positives = 0 if positives ==.
replace negatives = 0 if negatives ==.


* Open if Romer
replace positives = . if cyear >= 2008
replace negatives = . if cyear >= 2008

drop if cyear >= 2008
*/


by gvkeyn: gen int_share = xintq*100 / TotalDebt[_n-1]
gen logDebtIssuance = log(DebtIssuance)*100
gen logTotDebt = log(TotalDebt)*100
gen logRealAsset = log(atq/(gva_pindex/100))*100
gen logTotEmp = log(TotEmp)*100
rename TotalDebtGrowth DebtGrowth

* ================================================================

**** RESPONSE VARIABLE, POLICY VARIABLE AND INSTRUMENT INTERACTIONS.

* ================================================================

by gvkeyn: gen dppentq_r = drealppentq*100/L.realppentq

sum dppentq_r, det
bys qdate: egen Threshold99 = pctile(dppentq_r) if dppentq_r ! = ., p(99)
replace dppentq_r  = . if dppentq_r > Threshold99

sort gvkeyn qdate

capture macro drop response
global response  lnempC  // invratio // lnRealSales //     

cap drop dlogrealcapx
sort gvkeyn qdate 
by gvkeyn: gen d$response = $response - L.$response

capture macro drop policy_variable
global policy_variable gs1d 

capture macro drop ppolicy_variable
global ppolicy_variable gs1dp  

capture macro drop pnolicy_variable
global npolicy_variable gs1dn 

capture macro drop instrument
global instrument Extracted_MPShockE 

capture macro drop ninstrument
global ninstrument negatives 

capture macro drop pinstrument
global pinstrument positives 

drop if DebtAssetRatio < 0
drop if LiquidityRatio < 0
drop if saleq < 0
drop if invratio < 0

drop if cyear >= 2020


label var lnRealSales "Percent"
label var lnempC "Percent"
label var invratio "Percentage Points"


do "${mainpath}/Do/52A.LP_MP_Asym.do" 

